import QtQuick 2.0
import "../MedComponents"
Item {
    id: root
    signal requestBack()
    property int index: 0
    Rectangle {
        anchors.fill: parent
        color: "lightgrey"

        Rectangle {
            id: patientInfo
            anchors.left:parent.left
            width: parent.width * 0.5
            height: parent.height * 0.45
            color: "darkgrey"
            Text {
                id: lblInfo
                font.pixelSize: parent.height * 0.13
                text: "Patient Info"
            }
            Column {
                anchors.fill: parent
                anchors.topMargin: lblInfo.paintedHeight
                anchors.margins: 6
                Text {
                    id: lblName
                    font.pixelSize: parent.height * 0.13
                    text: "Name: " + dataModel.roleFromRow(index, "lastName") + ", " + dataModel.roleFromRow(index, "firstName")
                }

                Text {
                    id: lblDob
                    font.pixelSize: parent.height * 0.13
                    text: "D.O.B: " + dataModel.roleFromRow(index, "dob")
                }
                Text {
                    id: lblAddress
                    font.pixelSize: parent.height * 0.13
                    text: {
                        "Address\n  " +
                                dataModel.roleFromRow(index, "address") + "\n  " +
                                dataModel.roleFromRow(index, "city") + ", " + dataModel.roleFromRow(index, "state") + " " + dataModel.roleFromRow(index, "zipCode")
                    }
                }
            }
        }
        Rectangle {
            id :commentBox
            anchors.left: patientInfo.right
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.bottom: weightContainer.top
            color: "darkgrey"
            Text {
                id: lblComment
                font.pixelSize: parent.height * 0.13
                text: "Comments"
            }
            Rectangle {
                anchors.fill: parent
                anchors.topMargin: lblComment.paintedHeight
                anchors.margins: 6
                Text {
                    anchors.fill: parent
                    text: dataModel.roleFromRow(index, "comments")
                }
            }
        }

        Rectangle {
            id: weightContainer
            anchors.top: patientInfo.bottom
            anchors.bottom: btnEdit.top
            anchors.left: parent.left
            anchors.right: parent.right
            color: "lightblue"
            Text {
                id: weights
                font.pixelSize: parent.height * 0.1
                text: dataModel.roleFromRow(index, "weightData")
            }
        }

        Button {
            id: btnEdit
            anchors.bottom: parent.bottom
            anchors.right: parent.right
            height: parent.height * 0.1
            text: "Edit"
            onClicked: console.log("Edit Clicked")
        }

        Button {
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: btnEdit.left
            height: parent.height * 0.1
            text: "Back to List"
            onClicked: root.requestBack()
        }
    }
}
